/* $Id: utils.c,v 1.10 2005/06/19 19:47:14 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * imp/src/utils.c,v 1.3 2004/11/09 20:21:21 flaw
 * if/src/utils.c,v 1.28 2004/09/28 15:49:30 flaw
 *//*
 * Various Utilities
 */
#include <setjmp.h>
#include <postgres.h>
#include <access/attnum.h>
#include <access/tupdesc.h>
#include <access/htup.h>
#include <access/heapam.h>
#include <catalog/pg_type.h>
#include <catalog/pg_cast.h>
#include <catalog/catversion.h>
#include <executor/tuptable.h>
#include <nodes/params.h>
#include <parser/parse_type.h>
#include <utils/array.h>
#include <utils/elog.h>
#include <utils/rel.h>
#include <utils/builtins.h>
#include <utils/palloc.h>
#include <utils/relcache.h>
#include <utils/syscache.h>
#include <utils/tuplestore.h>
#include <tcop/tcopprot.h>
#include <pypg/environment.h>
#include <pypg/postgres.h>

#include <Python.h>
#include <structmember.h>
#include <pypg/python.h>

#include <pypg/externs.h>
#include <pypg/error.h>
#include <pypg/heaptuple.h>
#include <pypg/tupledesc.h>
#include <pypg/object.h>
#include <pypg/type.h>
#include <pypg/utils.h>
#include <pypg/conv.h>

PyObj
PyATTR(PyObj ob, char *str)
{
	PyObj pyattr = PyAttr(ob,str);
	XDECREF(pyattr);
	return(pyattr);
}

PyObj
PyMapITEM(PyObj ob, char *str)
{
	PyObj pyitem = PyMapItem(ob,str);
	XDECREF(pyitem);
	return(pyitem);
}

char _PyCFunctionErr_NoKeywordsAllowed(const char *_func, PyObj KW)
{	if (KW == NULL) return 0;
	PyErr_Format(PyExc_TypeError,
		"%s does not take keyword arguments", _func);
	return -1;
}

PyObj
Py_RETURN_SELF(PyObj self, ...)
{
	Py_INCREF(self);
	return(self);
}

/*
 * PySpec - Inspect a PyObj and print some info about it.
 * This is here to provide a function that the debugger can call.
 */
void
PySpec(PyObj ob)
{
	PySPEC(ob);
}

Oid
TypeOidMod_FromPyObject(PyObj ob, int32 *typmod)
{
	Oid typoid = InvalidOid;
	*typmod = -1;

	if (PyString_Check(ob))
	{
		parseTypeString(PyString_AS_STRING(ob), &typoid, typmod);
	}
	else if (PyPgType_Check(ob))
	{
		typoid = PyPgObject_FetchOid(ob);
	}
	else
	{
		typoid = Oid_FromPyObject(ob);
	}

	return(typoid);
}

Oid
TypeOid_FromPyObject(PyObj ob)
{
	int32 mod;
	return(TypeOidMod_FromPyObject(ob, &mod));
}

Oid
RelationId_FetchTypeOid(Oid rid)
{
	Relation rd;
	Oid rto;

	rd = RelationIdGetRelation(rid);
	if (rd == NULL)
	{
		PyErr_Format(PyExc_LookupError, 
			"failed to fetch Relation with Id \"%d\"", rid);
		return(0);
	}
	rto = rd->rd_rel->reltype;
	RelationClose(rd);

	return(rto);
}

Oid
RelationId_FromTypeOid(Oid typoid)
{
	HeapTuple tt;
	Oid rid;

	tt = SearchSysCache(TYPEOID, typoid, 0, 0, 0);
	rid = TYPESTRUCT(tt)->typrelid;
	ReleaseSysCache(tt);

	return(rid);
}

ParamListInfo
ParamListInfo_FromPyTuple(PyObj args)
{
	int i, argc = PyTuple_GET_SIZE(args);
	ParamListInfo pliq = palloc((argc + 1) * sizeof(ParamListInfoData));

	for (i = 0; i < argc; ++i)
	{
		ParamListInfo pli = &(pliq[i]);
		PyObj arg = PyTuple_GET_ITEM(args, i);

		pli->kind = PARAM_NUM;
		pli->name = NULL;
		pli->id = i + 1;
#if PGV_MM >= 80
		pli->ptype = PyPgObject_FetchTypeOid(arg);
#endif
		if (PyPgObject_IsNULL(arg))
		{
			pli->isnull = true;
			pli->value = 0;
		}
		else
		{
			pli->isnull = false;
			pli[i].value = PyPgObject_FetchDatum(arg);
		}
	}
	
	pliq[argc].kind = PARAM_INVALID;
	return(pliq);
}

char *
PgTypeName_FromOid(Oid typoid)
{
	char *pstr;
	HeapTuple ttup;

	ttup = SearchSysCache(TYPEOID, typoid, 0, 0, 0);
	pstr = pstrdup(NameStr(TYPESTRUCT(ttup)->typname));
	ReleaseSysCache(ttup);

	return(pstr);
}

Datum
Datum_Cast(Datum d, Oid from, Oid to)
{
	HeapTuple tup;
	Oid castor;
	Datum rd;
	
	tup = SearchSysCache(CASTSOURCETARGET, from, to, 0, 0);
	if (tup == NULL)
	{
		char *fromTypeStr, *toTypeStr;
		fromTypeStr = PgTypeName_FromOid(from);
		toTypeStr = PgTypeName_FromOid(to);

		ereport(ERROR,(
			errcode(ERRCODE_INVALID_NAME),
			errmsg("no function for casting a '%s' datum to a '%s' datum",
				fromTypeStr, toTypeStr)
		));
	}

	castor = CASTSTRUCT(tup)->castfunc;
	ReleaseSysCache(tup);

	rd = OidFunctionCall1(castor, d);
	return(rd);
}

HeapTupleHeader
HeapTupleHeader_FromHeapTuple(HeapTuple ht)
{
	HeapTupleHeader rot;

	rot = (HeapTupleHeader) palloc(ht->t_len);

	memcpy(rot, ht->t_data, ht->t_len);
	HeapTupleHeaderSetDatumLength(rot, ht->t_len);
	HeapTupleHeaderSetTypMod(rot, -1);
	HeapTupleHeaderSetTypeId(rot, RelationId_FetchTypeOid(ht->t_tableOid));

	return(rot);
}

PyObj
PyPgTypeTuple_FromPyObject(PyObj ob)
{
	Oid typ;

	typ = TypeOid_FromPyObject(ob);
	return(PyPgSearchSysCache(TYPEOID, (Datum)typ, 0, 0, 0));
}

/*
 * PyPgSearchSysCache
 *
 * Equivalent to SearchSysCache, but returns a PyObj instead of a HeapTuple.
 */
PyObj
PyPgSearchSysCache(int cacheId, Datum k1, Datum k2, Datum k3, Datum k4)
{
	HeapTuple htup;
	Oid httoid;
	PyObj to, rob;

	htup = SearchSysCache(cacheId, k1, k2, k3, k4);
	if (htup == NULL)
		return(NULL);

	httoid = HeapTuple_FetchTableOid(htup);
	to = PyPgType_FromRelationOid(httoid);
	if (to == NULL)
	{
		ReleaseSysCache(htup);
		return(NULL);
	}

	rob = PyPgObject_FromPyPgTypeAndHeapTuple(to, htup);
	ReleaseSysCache(htup);

	return(rob);
}

PyObj
pg_attribute_PyPgType(void)
{
	static PyObj rob = NULL;
	if (rob == NULL)
		rob = PyPgType_FromOid(PG_ATTRIBUTE_RELTYPE_OID);

	return(rob);
}

void
DirectR_Receive(HeapTuple tup, TupleDesc td, struct DirectReceiver *dr)
{
	dr->htup = tup;
	dr->tupd = td;
}

void
DirectR_Startup(struct DirectReceiver *dr, int op, TupleDesc td)
{
	dr->startupOperation = op;
	dr->startupDescriptor = td;
}

void
DirectR_Shutdown(struct DirectReceiver *dr) { }

void
DirectR_Destroy(struct DirectReceiver *dr) { }

void
DirectR_InitReceiver(struct DirectReceiver *dr)
{
	dr->receive = (DRReceive)		DirectR_Receive;
	dr->startup = (DRStartup)		DirectR_Startup;
	dr->shutdown= (DRShutdown)		DirectR_Shutdown;
	dr->destroy = (DRDestroy)		DirectR_Destroy;
	dr->dest		= (CommandDest)	0xFFA0;
}
/*
 * vim: ts=3:sw=3:noet:
 */
